using System;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using gov.va.med.vbecs;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.BOL;

namespace gov.va.med.vbecs.GUI
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/28/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>VBECS_UC_8 Blood Product Search Dialog User Interface</summary>

		#endregion

	public class DlgBloodProductSelect : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region Variables

		/// <summary>
		/// _bloodProduct
		/// </summary>
		private BOL.BloodProduct _bloodProduct;

		/// <summary>
		/// productTypeList
		/// </summary>
		private DataTable productTypeList;

		private DataTable _dtBloodProducts;
		
		#endregion

		#region Form Controls

		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpSelected;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label lblProductName;
		private System.Windows.Forms.Label lblProductCode;
		private System.Windows.Forms.TextBox txtProductCode;
		private System.Windows.Forms.ListView lvProducts;
		private System.Windows.Forms.TextBox txtProductName;
		private System.Windows.Forms.GroupBox grpResults;
		private System.Windows.Forms.GroupBox grpSearch;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbType;
		private System.Windows.Forms.Button btnSearch;
		private System.Windows.Forms.Label lblSearchString;
		private System.Windows.Forms.TextBox txtSearchString;
		private System.Windows.Forms.Label lblVolume;
		private System.Windows.Forms.Label lblShortName;
		private System.Windows.Forms.TextBox txtShortName;
		private System.Windows.Forms.CheckBox cbActive;
		private System.Windows.Forms.ColumnHeader colCode;
		private System.Windows.Forms.ColumnHeader colShortName;
		private System.Windows.Forms.ColumnHeader colFullName;
		private System.Windows.Forms.Label lblActive;
		private System.Windows.Forms.Label lblProductType;
		private gov.va.med.vbecs.GUI.controls.VbecsErrorProvider errorProvider1; // **** 508 Compliance ***
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.TextBox txtDays;
		private System.Windows.Forms.TextBox txtHours;
		private System.Windows.Forms.Label lblHours;
		private System.Windows.Forms.Label lblDays;
		private System.Windows.Forms.CheckBox cbCodabar;
		private System.Windows.Forms.CheckBox cbISBT;
		private System.Windows.Forms.TextBox txtVolume;
		private bool _codabar;
		
		#endregion

		#region Constructor/Destructor

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/28/2002</CreationDate>
		/// <summary> 
		/// DlgBloodProductSelect class constructor
		/// </summary>
		public DlgBloodProductSelect()
		{
			InitializeComponent();

			this.lblActive.Text = "Active in "+ ThisUser.CurrentDivisionRole.Division.DivisionName +"?";
           
			this._bloodProduct = new BOL.BloodProduct();

			SetComponentProperties();
			
			this.lvProducts.Items.Clear();
			productTypeList = BOL.ProductType.GetProductTypeLookupList();
			//
			PopulateTypeComboBox();
			PopulateSelectedProduct();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="codabar"></param>
		public DlgBloodProductSelect(bool codabar)
		{
			
			InitializeComponent();
			this.cbCodabar.Enabled = false;
			this.cbISBT.Enabled = false;
			this._codabar = codabar;
			this.cbCodabar.Checked = this._codabar;
			this.cbISBT.Checked = !this._codabar;

			this.lblActive.Text = "Active in "+ ThisUser.CurrentDivisionRole.Division.DivisionName +"?";
           
			this._bloodProduct = new BOL.BloodProduct();

			SetComponentProperties();
			
			this.lvProducts.Items.Clear();
			productTypeList = BOL.ProductType.GetProductTypeLookupList();
			//
			PopulateTypeComboBox();
			PopulateSelectedProduct();
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgBloodProductSelect));
			this.grpSelected = new System.Windows.Forms.GroupBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.txtHours = new System.Windows.Forms.TextBox();
			this.txtDays = new System.Windows.Forms.TextBox();
			this.lblHours = new System.Windows.Forms.Label();
			this.lblDays = new System.Windows.Forms.Label();
			this.lblActive = new System.Windows.Forms.Label();
			this.cbActive = new System.Windows.Forms.CheckBox();
			this.txtShortName = new System.Windows.Forms.TextBox();
			this.lblShortName = new System.Windows.Forms.Label();
			this.txtVolume = new System.Windows.Forms.TextBox();
			this.lblProductName = new System.Windows.Forms.Label();
			this.txtProductName = new System.Windows.Forms.TextBox();
			this.lblProductCode = new System.Windows.Forms.Label();
			this.txtProductCode = new System.Windows.Forms.TextBox();
			this.lblVolume = new System.Windows.Forms.Label();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpResults = new System.Windows.Forms.GroupBox();
			this.lvProducts = new System.Windows.Forms.ListView();
			this.colCode = new System.Windows.Forms.ColumnHeader();
			this.colShortName = new System.Windows.Forms.ColumnHeader();
			this.colFullName = new System.Windows.Forms.ColumnHeader();
			this.cbCodabar = new System.Windows.Forms.CheckBox();
			this.cbISBT = new System.Windows.Forms.CheckBox();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpSearch = new System.Windows.Forms.GroupBox();
			this.cmbType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblProductType = new System.Windows.Forms.Label();
			this.btnSearch = new System.Windows.Forms.Button();
			this.txtSearchString = new System.Windows.Forms.TextBox();
			this.lblSearchString = new System.Windows.Forms.Label();
			this.errorProvider1 = new gov.va.med.vbecs.GUI.controls.VbecsErrorProvider();
			this.grpSelected.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.grpResults.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpSearch.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(568, 30);
			this.vbecsLogo1.TabIndex = 5;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 400);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpSelected
			// 
			this.grpSelected.AccessibleDescription = "Selected Product";
			this.grpSelected.AccessibleName = "Selected Product";
			this.grpSelected.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSelected.Controls.Add(this.groupBox1);
			this.grpSelected.Controls.Add(this.lblActive);
			this.grpSelected.Controls.Add(this.cbActive);
			this.grpSelected.Controls.Add(this.txtShortName);
			this.grpSelected.Controls.Add(this.lblShortName);
			this.grpSelected.Controls.Add(this.txtVolume);
			this.grpSelected.Controls.Add(this.lblProductName);
			this.grpSelected.Controls.Add(this.txtProductName);
			this.grpSelected.Controls.Add(this.lblProductCode);
			this.grpSelected.Controls.Add(this.txtProductCode);
			this.grpSelected.Controls.Add(this.lblVolume);
			this.grpSelected.Location = new System.Drawing.Point(360, 32);
			this.grpSelected.Name = "grpSelected";
			this.grpSelected.Size = new System.Drawing.Size(204, 347);
			this.grpSelected.TabIndex = 2;
			this.grpSelected.TabStop = false;
			this.grpSelected.Text = "Selected Product";
			// 
			// groupBox1
			// 
			this.groupBox1.AccessibleDescription = "Maximum Storage Time";
			this.groupBox1.AccessibleName = "Maximum Storage Time";
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.txtHours);
			this.groupBox1.Controls.Add(this.txtDays);
			this.groupBox1.Controls.Add(this.lblHours);
			this.groupBox1.Controls.Add(this.lblDays);
			this.groupBox1.Location = new System.Drawing.Point(8, 235);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(188, 48);
			this.groupBox1.TabIndex = 10;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Maximum Storage Time";
			// 
			// txtHours
			// 
			this.txtHours.AccessibleDescription = "Hours";
			this.txtHours.AccessibleName = "Hours";
			this.txtHours.Location = new System.Drawing.Point(136, 18);
			this.txtHours.Name = "txtHours";
			this.txtHours.ReadOnly = true;
			this.txtHours.Size = new System.Drawing.Size(40, 20);
			this.txtHours.TabIndex = 12;
			this.txtHours.Text = "";
			// 
			// txtDays
			// 
			this.txtDays.AccessibleDescription = "Days";
			this.txtDays.AccessibleName = "Days";
			this.txtDays.Location = new System.Drawing.Point(40, 18);
			this.txtDays.Name = "txtDays";
			this.txtDays.ReadOnly = true;
			this.txtDays.Size = new System.Drawing.Size(40, 20);
			this.txtDays.TabIndex = 11;
			this.txtDays.Text = "";
			// 
			// lblHours
			// 
			this.lblHours.Location = new System.Drawing.Point(100, 18);
			this.lblHours.Name = "lblHours";
			this.lblHours.Size = new System.Drawing.Size(40, 20);
			this.lblHours.TabIndex = 2;
			this.lblHours.Text = "Hours";
			this.lblHours.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblDays
			// 
			this.lblDays.Location = new System.Drawing.Point(8, 18);
			this.lblDays.Name = "lblDays";
			this.lblDays.Size = new System.Drawing.Size(32, 20);
			this.lblDays.TabIndex = 0;
			this.lblDays.Text = "Days";
			this.lblDays.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblActive
			// 
			this.lblActive.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblActive.Location = new System.Drawing.Point(8, 315);
			this.lblActive.Name = "lblActive";
			this.lblActive.Size = new System.Drawing.Size(156, 20);
			this.lblActive.TabIndex = 9;
			this.lblActive.Text = "Active in Division?";
			this.lblActive.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbActive
			// 
			this.cbActive.AccessibleDescription = "Active in Division?";
			this.cbActive.AccessibleName = "Active in Division?";
			this.cbActive.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cbActive.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbActive.Enabled = false;
			this.cbActive.Location = new System.Drawing.Point(132, 315);
			this.cbActive.Name = "cbActive";
			this.cbActive.Size = new System.Drawing.Size(64, 24);
			this.cbActive.TabIndex = 14;
			// 
			// txtShortName
			// 
			this.txtShortName.AccessibleDescription = "Short Product Name";
			this.txtShortName.AccessibleName = "Short Product Name";
			this.txtShortName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtShortName.Location = new System.Drawing.Point(8, 56);
			this.txtShortName.Name = "txtShortName";
			this.txtShortName.ReadOnly = true;
			this.txtShortName.Size = new System.Drawing.Size(188, 20);
			this.txtShortName.TabIndex = 8;
			this.txtShortName.Text = "";
			// 
			// lblShortName
			// 
			this.lblShortName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblShortName.Location = new System.Drawing.Point(8, 40);
			this.lblShortName.Name = "lblShortName";
			this.lblShortName.Size = new System.Drawing.Size(188, 16);
			this.lblShortName.TabIndex = 2;
			this.lblShortName.Text = "Short Product Name";
			this.lblShortName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtVolume
			// 
			this.txtVolume.AccessibleDescription = "Volume milliliters";
			this.txtVolume.AccessibleName = "Volume milliliters";
			this.txtVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtVolume.Location = new System.Drawing.Point(88, 291);
			this.txtVolume.Name = "txtVolume";
			this.txtVolume.ReadOnly = true;
			this.txtVolume.Size = new System.Drawing.Size(108, 20);
			this.txtVolume.TabIndex = 13;
			this.txtVolume.Text = "";
			// 
			// lblProductName
			// 
			this.lblProductName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblProductName.Location = new System.Drawing.Point(8, 80);
			this.lblProductName.Name = "lblProductName";
			this.lblProductName.Size = new System.Drawing.Size(188, 16);
			this.lblProductName.TabIndex = 4;
			this.lblProductName.Text = "Full Product Name";
			this.lblProductName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtProductName
			// 
			this.txtProductName.AccessibleDescription = "Full Product Name";
			this.txtProductName.AccessibleName = "Full Product Name";
			this.txtProductName.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProductName.Location = new System.Drawing.Point(8, 96);
			this.txtProductName.Multiline = true;
			this.txtProductName.Name = "txtProductName";
			this.txtProductName.ReadOnly = true;
			this.txtProductName.Size = new System.Drawing.Size(188, 135);
			this.txtProductName.TabIndex = 9;
			this.txtProductName.Text = "";
			// 
			// lblProductCode
			// 
			this.lblProductCode.Location = new System.Drawing.Point(8, 16);
			this.lblProductCode.Name = "lblProductCode";
			this.lblProductCode.Size = new System.Drawing.Size(80, 20);
			this.lblProductCode.TabIndex = 0;
			this.lblProductCode.Text = "Product Code";
			this.lblProductCode.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtProductCode
			// 
			this.txtProductCode.AccessibleDescription = "product code";
			this.txtProductCode.AccessibleName = "product code";
			this.txtProductCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProductCode.Location = new System.Drawing.Point(88, 16);
			this.txtProductCode.Name = "txtProductCode";
			this.txtProductCode.ReadOnly = true;
			this.txtProductCode.Size = new System.Drawing.Size(108, 20);
			this.txtProductCode.TabIndex = 7;
			this.txtProductCode.Text = "";
			// 
			// lblVolume
			// 
			this.lblVolume.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblVolume.Location = new System.Drawing.Point(8, 291);
			this.lblVolume.Name = "lblVolume";
			this.lblVolume.Size = new System.Drawing.Size(80, 20);
			this.lblVolume.TabIndex = 7;
			this.lblVolume.Text = "Volume (mL)";
			this.lblVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Enabled = false;
			this.btnOK.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnOK.Location = new System.Drawing.Point(408, 387);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 15;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(488, 387);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 16;
			this.btnCancel.Text = "&Cancel";
			// 
			// grpResults
			// 
			this.grpResults.AccessibleDescription = "Search Results";
			this.grpResults.AccessibleName = "Search Results";
			this.grpResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpResults.Controls.Add(this.lvProducts);
			this.grpResults.Controls.Add(this.cbCodabar);
			this.grpResults.Controls.Add(this.cbISBT);
			this.grpResults.Location = new System.Drawing.Point(60, 128);
			this.grpResults.Name = "grpResults";
			this.grpResults.Size = new System.Drawing.Size(296, 251);
			this.grpResults.TabIndex = 3;
			this.grpResults.TabStop = false;
			this.grpResults.Text = "Search Results";
			// 
			// lvProducts
			// 
			this.lvProducts.AccessibleDescription = "Product Search Results";
			this.lvProducts.AccessibleName = "Product Search Results";
			this.lvProducts.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvProducts.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.colCode,
																						 this.colShortName,
																						 this.colFullName});
			this.lvProducts.FullRowSelect = true;
			this.lvProducts.HideSelection = false;
			this.lvProducts.Location = new System.Drawing.Point(8, 16);
			this.lvProducts.MultiSelect = false;
			this.lvProducts.Name = "lvProducts";
			this.lvProducts.Size = new System.Drawing.Size(282, 195);
			this.lvProducts.TabIndex = 4;
			this.lvProducts.View = System.Windows.Forms.View.Details;
			this.lvProducts.DoubleClick += new System.EventHandler(this.lvProducts_DoubleClick);
			this.lvProducts.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvProducts_ColumnClick);
			this.lvProducts.SelectedIndexChanged += new System.EventHandler(this.lvProducts_SelectedIndexChanged);
			// 
			// colCode
			// 
			this.colCode.Text = "Code";
			this.colCode.Width = 70;
			// 
			// colShortName
			// 
			this.colShortName.Text = "Short Product Name";
			this.colShortName.Width = 215;
			// 
			// colFullName
			// 
			this.colFullName.Text = "Full Product Name";
			this.colFullName.Width = 300;
			// 
			// cbCodabar
			// 
			this.cbCodabar.AccessibleDescription = "Show Codabar Products";
			this.cbCodabar.AccessibleName = "Show Codabar Products";
			this.cbCodabar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cbCodabar.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbCodabar.Checked = true;
			this.cbCodabar.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbCodabar.Location = new System.Drawing.Point(8, 213);
			this.cbCodabar.Name = "cbCodabar";
			this.cbCodabar.Size = new System.Drawing.Size(152, 16);
			this.cbCodabar.TabIndex = 5;
			this.cbCodabar.Text = "Show Co&dabar Products";
			this.cbCodabar.CheckedChanged += new System.EventHandler(this.BarcodeTypeChanged);
			// 
			// cbISBT
			// 
			this.cbISBT.AccessibleDescription = "Show I S B T Products";
			this.cbISBT.AccessibleName = "Show I S B T Products";
			this.cbISBT.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cbISBT.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbISBT.Checked = true;
			this.cbISBT.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbISBT.Location = new System.Drawing.Point(8, 231);
			this.cbISBT.Name = "cbISBT";
			this.cbISBT.Size = new System.Drawing.Size(152, 16);
			this.cbISBT.TabIndex = 6;
			this.cbISBT.Text = "Show &ISBT 128 Products";
			this.cbISBT.CheckedChanged += new System.EventHandler(this.BarcodeTypeChanged);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 347);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 38;
			this.pictureBox1.TabStop = false;
			// 
			// grpSearch
			// 
			this.grpSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearch.Controls.Add(this.cmbType);
			this.grpSearch.Controls.Add(this.lblProductType);
			this.grpSearch.Controls.Add(this.btnSearch);
			this.grpSearch.Controls.Add(this.txtSearchString);
			this.grpSearch.Controls.Add(this.lblSearchString);
			this.grpSearch.Location = new System.Drawing.Point(60, 32);
			this.grpSearch.Name = "grpSearch";
			this.grpSearch.Size = new System.Drawing.Size(296, 96);
			this.grpSearch.TabIndex = 0;
			this.grpSearch.TabStop = false;
			this.grpSearch.Text = "Search Criteria";
			// 
			// cmbType
			// 
			this.cmbType.AccessibleDescription = "Product Type";
			this.cmbType.AccessibleName = "Product Type";
			this.cmbType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbType.Interval = 1000;
			this.cmbType.Location = new System.Drawing.Point(88, 16);
			this.cmbType.Name = "cmbType";
			this.cmbType.Size = new System.Drawing.Size(200, 22);
			this.cmbType.TabIndex = 0;
			this.cmbType.SelectedIndexChanged += new System.EventHandler(this.cmbType_SelectedIndexChanged);
			// 
			// lblProductType
			// 
			this.lblProductType.Location = new System.Drawing.Point(8, 16);
			this.lblProductType.Name = "lblProductType";
			this.lblProductType.Size = new System.Drawing.Size(80, 20);
			this.lblProductType.TabIndex = 0;
			this.lblProductType.Text = "Product Type *";
			this.lblProductType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSearch
			// 
			this.btnSearch.AccessibleDescription = "Search";
			this.btnSearch.AccessibleName = "Search";
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Enabled = false;
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnSearch.Location = new System.Drawing.Point(212, 64);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.TabIndex = 2;
			this.btnSearch.Text = "&Search";
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// txtSearchString
			// 
			this.txtSearchString.AccessibleDescription = "Partial Product Name";
			this.txtSearchString.AccessibleName = "Partial Product Name";
			this.txtSearchString.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSearchString.Location = new System.Drawing.Point(120, 40);
			this.txtSearchString.MaxLength = 40;
			this.txtSearchString.Name = "txtSearchString";
			this.txtSearchString.Size = new System.Drawing.Size(168, 20);
			this.txtSearchString.TabIndex = 1;
			this.txtSearchString.Text = "";
			this.txtSearchString.TextChanged += new System.EventHandler(this.EnableSearchButton);
			// 
			// lblSearchString
			// 
			this.lblSearchString.Location = new System.Drawing.Point(8, 40);
			this.lblSearchString.Name = "lblSearchString";
			this.lblSearchString.Size = new System.Drawing.Size(120, 20);
			this.lblSearchString.TabIndex = 2;
			this.lblSearchString.Text = "Partial Product Name";
			this.lblSearchString.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// DlgBloodProductSelect
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(568, 416);
			this.Controls.Add(this.grpSearch);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpResults);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpSelected);
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MinimumSize = new System.Drawing.Size(530, 360);
			this.Name = "DlgBloodProductSelect";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "VBECS - Blood Product Search";
			this.Controls.SetChildIndex(this.grpSelected, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpResults, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpSearch, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpSelected.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.grpResults.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpSearch.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/28/2002</CreationDate>
		///<summary>
		///Selected Blood Product. Read only property.
		///</summary>
		public BOL.BloodProduct BloodProduct
		{
			get 
			{ 
				return this._bloodProduct; 
			}
		}


		#endregion

		#region Methods

		/// <summary>
		/// PopulateSelectedProduct
		/// </summary>
		private void PopulateSelectedProduct()
		{
			this.ResetLockTimer(this, System.EventArgs.Empty);

			
			if (this._bloodProduct.IsNew)
			{
				ClearDisplayResults();
				return;
			}
			//
			txtProductCode.Text = this._bloodProduct.ProductCode;
			txtShortName.Text = this._bloodProduct.ProductShortName;
			txtProductName.Text = this._bloodProduct.ProductName;
			txtDays.Text = this._bloodProduct.MaximumStorageDays.ToString();
			txtHours.Text = this._bloodProduct.MaximumStorageHours.ToString();
			txtVolume.Text = this._bloodProduct.ProductVolume.ToString();
			cbActive.Checked = this._bloodProduct.ProductActiveIndicator;
			//
			btnOK.Enabled = (!txtProductName.Text.Equals(string.Empty));
		}

		/// <summary>
		/// Set properties of user controls. IDE has a nasty habit of overriding values set at design time.
		/// </summary>
		private void SetComponentProperties()
		{
			vbecsLogo1.Title="Blood Product Search";
			RequiredFieldsLabel = true;
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC008.DlgBloodProductSelect());
		}


		/// <summary>
		/// Fill Type ComboBox with BloodProduct class properties.
		/// </summary>
		private void PopulateTypeComboBox()
		{
			this.cmbType.Items.Clear();

			foreach(DataRow dr in productTypeList.Rows)
			{
				this.cmbType.Items.Add(dr[Common.VbecsTables.ProductType.ProductTypeName]);
				
			}
		}


		/// <summary>
		/// Initiate search of database for blood products matching search criteria. Load listview with results.
		/// </summary>
		private void ProductSearch()
		{
			try
			{
				string productTypeCode = String.Empty;

				this.Working();
				
				//The user can type and click search before the timer fires, causing the SelectedIndex to be -1.  So, we must check it
				if (this.cmbType.SelectedIndex > -1)
				{
					productTypeCode = this.productTypeList.Rows[this.cmbType.SelectedIndex][Common.VbecsTables.BloodProduct.ProductTypeCode].ToString();
				}
				else
				{
					productTypeCode = this.cmbType.Text;
				}

				_dtBloodProducts = BOL.BloodProduct.BloodProductSearch(txtSearchString.Text,productTypeCode);
			
				
				LoadBloodProducts();
			}
			catch ( Exception err)
			{
				this.Stopped();
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
			}
			finally
			{
				this.Ready();
			}
		}


		/// <summary>
		/// ClearDisplayResults
		/// </summary>
		private void ClearDisplayResults()
		{	
			this.ResetLockTimer(this, System.EventArgs.Empty);

			//Clear out the old display information
			txtProductCode.Text = String.Empty;
			txtShortName.Text = String.Empty;
			txtProductName.Text = String.Empty;
			txtVolume.Text = String.Empty;
			txtDays.Text = String.Empty;
			txtHours.Text = String.Empty;
			cbActive.Checked = false;
			this.btnOK.Enabled = false;
		}

		/// <summary>
		/// Load listview control with contents of given blood product data table.
		/// </summary>
		private void LoadBloodProducts()
		{
			lvProducts.Items.Clear();
			//
			if (_dtBloodProducts != null)
			{
				foreach (DataRow drProduct in _dtBloodProducts.Rows)
				{
					ListViewItem _lviBloodProduct = new ListViewItem(drProduct[Common.VbecsTables.BloodProduct.ProductCode].ToString());
					_lviBloodProduct.SubItems.Add(drProduct[Common.VbecsTables.BloodProduct.ProductShortName].ToString());
					_lviBloodProduct.SubItems.Add(drProduct[Common.VbecsTables.BloodProduct.ProductName].ToString());
					_lviBloodProduct.Tag = drProduct;
					//
					bool barcodeType = (bool)drProduct[Common.DatabaseConstants.ArtificialColumnNames.BarcodeType];
					if ((cbCodabar.Checked && !barcodeType)||(cbISBT.Checked && barcodeType))
					{
						lvProducts.Items.Add(_lviBloodProduct);
					}
				}
				if(lvProducts.Items.Count == 0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC020.NoMatchingEntries());
				}
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvProducts);
		}


		#endregion

		#region Control Events

		/// <summary>
		/// btnOK_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.ResetLockTimer(this, System.EventArgs.Empty);
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		/// <summary>
		/// lvProducts SelectedIndexChanged event. Load blood product from selected row.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvProducts_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (lvProducts.SelectedIndices.Count > 0)
			{
				try
				{
					DataRow selected = (DataRow)lvProducts.SelectedItems[0].Tag;

					this._bloodProduct = new BloodProduct((System.Guid)selected[Common.VbecsTables.BloodProduct.BloodProductGuid]);
					//Don't loadfrom datarow -- to avoid stale data
					PopulateSelectedProduct();
					this.errorProvider1.SetVbecsError(this.txtProductCode, string.Empty); // **** 508 Compliance ***
				}
				catch (Exception err)
				{
					this.errorProvider1.SetVbecsError(this.txtProductCode, err.Message); // **** 508 Compliance ***
				}
			}
		}

		

		/// <summary>
		/// btnSearch Click event. Initiates product search. Ensures that no rows are selected in listview.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			ProductSearch();
			//
			lvProducts.SelectedItems.Clear();
			lvProducts.Focus();
			
			this.ClearDisplayResults();
			
		}

		/// <summary>
		/// lvProducts DoubleClick event. Selects row and initiates btnOK Click event.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvProducts_DoubleClick(object sender, System.EventArgs e)
		{
			if (lvProducts.SelectedItems.Count > 0)
			{
				btnOK_Click(sender,e);
			}
		}

		/// <summary>
		/// lvProducts ColumnClick event. Sorts listview items based on column clicked.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvProducts_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			this.ResetLockTimer(this, System.EventArgs.Empty);
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvProducts.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
		}

		/// <summary>
		/// cmbType_SelectedIndexChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.ClearDisplayResults();
			this.EnableSearchButton(null, System.EventArgs.Empty);
		}


		#endregion

		#region Events

		/// <summary>
		/// Private method which enables btnSearch event if either a product type code has been entered or 3 characters of a product name have been entered.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void EnableSearchButton(object sender, System.EventArgs e)
		{
			//Product Type is Required
			btnSearch.Enabled = (cmbType.SelectedIndex > -1);
		}


		#endregion

		private void BarcodeTypeChanged(object sender, System.EventArgs e)
		{
			this.ResetLockTimer(this, System.EventArgs.Empty);
			this.LoadBloodProducts();
		}

	}
}
